{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

{fetch_articles perPage=5 assign=vacancies query=$query assignPagination=pagination page=$page section=$section.sectionId path=$section.path seFriendly=true typeContent="vacancys" image=true}

<main class="main">

	{* banner page *}
	{include file="modules/banner.tpl"}
	{* /banner page *}

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="grid:fr-1 g-gap-40 max-w-1000 x-center">

					{* Поиск *}
					{include file="form/search-form.tpl"}
					{* /Поиск *}

					<div class="grid:fr-1 g-gap-20">

						{foreach from=$vacancies item=vacancy}
							<div class="job-card">
								<div class="job-card__head">
									<div class="text-tmp txt-accent-6 txt-14">
										<p>Дата публикации: {$vacancy.publishedOn|date_format:$config.date_format_custom}</p>
									</div>
								</div>

								<div class="job-card__content">
									<div class="text-tmp title-20 title-tt-up title-accent">
										<h2>{$vacancy.title}</h2>
										{$vacancy.summary nofilter}
									</div>
								</div>

								<div class="job-card__footer">
									<a class="btn accent transparent" href="{$SITE_URL}{$vacancy.url}">Откликнутся</a>
								</div>
							</div>
						{/foreach}
					</div>

					{* pagination *}
					{include file="modules/pagination.tpl" class="pagination x-right"}
					{* /pagination *}
				</div>
			</div>

			{* decor *}
			<div class="decor-triangle">
				{include file="icon/svg.tpl" svgId="decor_triangle" fill="none"}
			</div>
			{* /decor *}

		</div>
	</section>

	{* Котакты *}
	{include file="blocks/contacts.tpl"}
	{* /Котакты *}

</main>


{include file="footer.tpl"}