{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}


{fetch_articles perPage=5 assign=tenders query=$query assignPagination=pagination page=$page section=$section.sectionId path=$section.path seFriendly=true typeContent="tenders" image=true imageType="docs"}

<main class="main">

	{* banner page *}
	{include file="modules/banner.tpl"}
	{* /banner page *}

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="grid:fr-1 g-gap-40 max-w-1000 x-center">

					{* Поиск *}
					{include file="form/search-form.tpl"}
					{* /Поиск *}

					<div class="grid:fr-1 g-gap-20">

						{foreach from=$tenders item=tender}
							<div class="tender-card" id="{$tender.alias}">
								<div class="tender-card__head">
									<div class="text-tmp txt-accent-6 txt-14"><p>Тендер №{$tender.alias}</p></div>
								</div>

								<div class="tender-card__content">
									<div class="text-tmp title-20 title-tt-up title-accent"><h2>{$tender.title}</h2></div>
									<div class="tender-card__content-lists">{$tender.summary nofilter}</div>
								</div>

								<div class="tender-card__footer">
									<div class="tender-card__footer-btns">
										{if !empty($tender.tender_phone)}
											<a class="btn accent transparent" href="tel:{$tender.tender_phone|format_phone}">{$tender.tender_phone|format_phone}</a>
										{/if}
										{if !empty($tender.tender_email)}
											<a class="btn accent transparent" href="mailto:{$tender.tender_email}">{$tender.tender_email}</a>
										{/if}
									</div>

									<div class="tender-card__footer-btns">
										<button class="btn accent transparent tender-btn_js" data-modal-id="applicationModal">Оставить заявку</button>
										{if !empty($tender.docs)}
											{assign var=doc value=$tender.docs|first}
											<a class="btn accent-2" href="{$doc.original}">Скачать</a>
										{/if}
									</div>
								</div>
							</div>
						{/foreach}
					</div>

					{* pagination *}
					{include file="modules/pagination.tpl" class="pagination x-right"}
					{* /pagination *}

				</div>
			</div>

			{* decor *}
			<div class="decor-triangle">
				{include file="icon/svg.tpl" svgId="decor_triangle" fill="none"}
			</div>
			{* /decor *}

		</div>
	</section>

	{* Котакты *}
	{include file="blocks/contacts.tpl"}
	{* /Котакты *}

</main>

<div class="d-none">
	<div class="modal-tender" id="applicationModal">
		<div class="modal-tender__inner">
			{* tender form *}
			{include file="form/tender-form.tpl"}
			{* /tender form *}
		</div>
	</div>
</div>

{include file="footer.tpl"}