{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

{fetch_articles perPage=50 assign=teams section=$section.sectionId assignPagination=pagination page=$page path=$section.path seFriendly=true image=true}

<main class="main">

	{* banner page *}
	{include file="modules/banner.tpl"}
	{* /banner page *}

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="block-head">
					<div class="text-tmp title-32 title-tt-up title-accent all-center max-w-768 x-center">
						{$section.content|page_break:null nofilter}
					</div>
				</div>

				<div class="grid:fr-3 g-gap-20 max">
					{foreach from=$teams item=team}
						<div class="team-card">
							<div class="team-card__img"><img src="{$team.image.original}" alt="{$team.title}"></div>
							<div class="team-card__info">
								<div class="text-tmp title-20 title-dec-14 title-accent title-tt-up marg-all-10">
									<h3>{$team.title}</h3>
									<h4>{$team.alias}</h4>
									{$team.summary nofilter}
								</div>
							</div>
						</div>
					{/foreach}
				</div>
			</div>

			{* decor *}
			<div class="decor-triangle">
				{include file="icon/svg.tpl" svgId="decor_triangle" fill="none"}
			</div>
			{* /decor *}

		</div>
	</section>

</main>


{include file="footer.tpl"}