{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

{fetch_articles perPage=5 assign=projects section=$section.sectionId assignPagination=pagination page=$page path=$section.path seFriendly=true typeContent="projects" image=true}

<main class="main">
	{* banner page *}
	{include file="modules/banner.tpl"}
	{* /banner page *}

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="block-head">
					<div class="text-tmp title-40 title-tt-up title-accent-2"><h2>Наши проекты</h2></div>
				</div>

				<div class="grid:fr-1 g-gap-40">
					<div class="grid:fr-1 g-gap-20">
						{foreach from=$projects item=project}
							<div class="project-card" data-aos="fade-up" data-aos-duration="500">
								<div class="project-card__img">
									<div class="text-tmp"><img src="{$project.image.original}" alt="{$project.title}"></div>
								</div>

								<div class="project-card__info">
									<div class="text-tmp title-40 title-accent">
										<h3>{$project.title}</h3>
										<p>{$project.summary|page_break:0 nofilter}</p>
									</div>

									<div class="project-card__info-lists">
										{$project.summary|page_break:1 nofilter}
									</div>

									<a class="btn accent transparent" href="{$SITE_URL}{$project.url}">Подробнее</a>
								</div>
							</div>
						{/foreach}
					</div>

					{* pagination *}
					{include file="modules/pagination.tpl" class="pagination x-right"}
					{* /pagination *}

				</div>
			</div>
		</div>
	</section>

	{* Котакты *}
	{include file="blocks/contacts.tpl"}
	{* /Котакты *}

</main>

{include file="footer.tpl"}