{strip}
    {fetch_banners assign=banners limit=10 section=$section.sectionId}
    {if !empty($banners)}
		<section class="flex:col">
			<div class="intro">
				<div class="swiper intro-slider_js">
					<div class="swiper-wrapper">
						{foreach item=banner from=$banners name=banners}
						<div class="swiper-slide">
							<div class="intro__item">
								<div class="intro__item-info" data-swiper-parallax="60%">
									<div class="text-tmp color-white title-48 all-center">
										{if $smarty.foreach.banners.first}
											<h1>{$banner.title nofilter}</h1>
										{else}
											<h2>{$banner.title nofilter}</h2>
										{/if}

										{$banner.summary nofilter}
									</div>

									{if !empty($banner.url)}
										<a class="btn accent-2 large" href="{$SITE_URL}{$banner.url}">Подробнее</a>
									{/if}
								</div>

								<div class="intro__item-bg" data-swiper-parallax="90%">
									<picture>
										<source srcset="{$banner.images.medium}" media="(max-width: 550px)" />
										<source srcset="{$banner.images.medium}" media="(max-width: 768px)" />
										<source srcset="{$banner.images.large}" media="(max-width: 1024px)" />
										<source srcset="{$banner.images.original}" media="(max-width: 1440px)" />
										<img src="{$banner.images.original}" alt="{$banner.title nofilter}" />
									</picture>
								</div>
							</div>
						</div>
						{/foreach}
					</div>
				</div>

				<div class="intro__pagination"></div>

				<div class="intro__decor">
					<svg width="1920" height="235" viewBox="0 0 1920 235" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
						<path d="M0 0C640 156.667 1280 156.667 1920 0C1920 156.667 1920 235 1920 235C640 235 0 235 0 235C0 78.3333 0 0 0 0Z" fill="white" />
					</svg>

				</div>
			</div>
		</section>
	{/if}
{/strip}