{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

	{* intro slider *}
	{include file="modules/slider.tpl"}
	{* /intro slider *}

	{* о компании -*}
	{fetch_section assign=aboutSection section=2 getContent=true}{if !empty($aboutSection) && $aboutSection.status eq 'V'}
	<section class="flex:col pad-t-50 over-hide">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-150">
				<div class="text-tmp title-40 title-tt-up title-accent-2 all-center x-center max-w-768">
					<h2>{$aboutSection.name}</h2>
					{$aboutSection.content|page_break:0 nofilter}
				</div>

				{* коллонны в цифрах *}
				{include file="blocks/about-numbers.tpl" items=$aboutSection}
				{* /коллонны в цифрах *}
			</div>
		</div>
		{* data-aos="fade-right" data-aos-delay="300" data-aos-duration="1000" data-aos="fade-left" data-aos-delay="300" data-aos-duration="1000" *}
		<div class="decor-img-left building large bot anim-left_js"><img src="{$ASSETS_URL}/images/common/decor/claud-left-building.png" alt=""></div>
		<div class="decor-img-right building large bot anim-right_js"><img src="{$ASSETS_URL}/images/common/decor/claud-right-building.png" alt=""></div>
	</section>
	{/if}
	{* /о компании *}

	{* Почему нам доверяют? *}
	{include file="blocks/why.tpl"}
	{* /Почему нам доверяют? *}


	{* Услуги *}
	{fetch_section assign=servicesSection section=3 getContent=true}{if !empty($servicesSection) && $servicesSection.status eq 'V'}
	<section class="flex:col pad-tb-50 over-hide">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="block-head">
					<div class="text-tmp title-40 title-tt-up title-accent-2"><h2>{$servicesSection.name}</h2></div>
					<a class="link-more" href="{$SITE_URL}{$servicesSection.url}">Все услуги</a>
				</div>

				{fetch_sections assign=services from=$servicesSection.sectionId status="V" image=true}{if !empty($services)}
				<div class="service-slider" data-aos="fade-up" data-aos-duration="1000">
					<div class="swiper service-slider_js">
						<div class="swiper-wrapper">
							{foreach item=service from=$services name=services}
								<div class="swiper-slide">
									{* service item *}
									{include file="items/service.tpl"}
									{* /service item *}
								</div>
							{/foreach}
						</div>
					</div>

					<div class="service-slider__ui">
						<button class="arrow-slider service-prev_js">
							<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
								<path d="M366.924-213.463 100.001-480.385l266.923-266.922 41.768 41.768-194.54 195.155h646.231v59.999H214.537l195.155 195.154-42.768 41.768Z" />
							</svg>
						</button>
						<div class="service-slider__pagination"></div>
						<button class="arrow-slider service-next_js">
							<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
								<path d="m593.461-213.463-42.768-41.768 195.155-195.154H100.001v-59.999h646.231L551.693-705.539l41.768-41.768 266.922 266.922-266.922 266.922Z" />
							</svg>
						</button>
					</div>
				</div>
				{/if}
			</div>
		</div>
	</section>
	{/if}
	{* /Услуги *}

	{* Новости *}
	{fetch_section assign=newsSection section=5 getContent=true}{if !empty($newsSection) && $newsSection.status eq 'V'}
		<section class="flex:col pad-tb-50 over-hide">
			<div class="flex:col-max">
				<div class="grid:fr-1 g-gap-40">
					<div class="block-head">
						<div class="text-tmp title-40 title-tt-up title-accent-2"><h2>{$newsSection.name}</h2></div>
						<a class="link-more" href="{$SITE_URL}{$newsSection.url}">Все новости</a>
					</div>

					{fetch_articles limit=4 assign=news section=$newsSection.sectionId image=true}{if !empty($news)}
					<div class="news">
						{foreach from=$news item=new name=news}{if $smarty.foreach.news.first}
							{* news item *}
							{include file="items/news.tpl" type="" position="right" truncateTitle=64 truncateSummary=200}
							{* /news item *}
						{/if}{/foreach}
						<div class="news__col">
							{foreach from=$news item=new name=news}{if !$smarty.foreach.news.first}
								{* news item *}
								{include file="items/news.tpl" type="gorizontal" position="left" truncateTitle=34 truncateSummary=100}
								{* /news item *}
							{/if}{/foreach}
						</div>
					</div>
					{/if}
				</div>
			</div>
		</section>
	{/if}
	{* /Новости *}

	{* Проекты *}
	{fetch_section assign=projectsSection section=4 getContent=true}{if !empty($projectsSection) && $projectsSection.status eq 'V'}
	<section class="flex:col pad-tb-50 over-hide">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="block-head">
					<div class="text-tmp title-40 title-tt-up title-accent-2"><h2>{$projectsSection.alias}</h2></div>
					<a class="link-more" href="{$SITE_URL}{$projectsSection.url}">Все проекты</a>
				</div>

				{fetch_articles limit=2 assign=projects section=$projectsSection.sectionId typeContent="projects" image=true}
				{foreach from=$projects item=project name=projects}
					<div class="grid:fr-2 g-gap-40">
						{if $smarty.foreach.projects.iteration%2!=0}
						<div class="grid:fr-1 g-gap-40" data-aos="fade-up" data-aos-duration="500">
							<div class="text-tmp title-36 title-accent max-w-650"><img src="{$project.image.original}" alt="{$project.title}"></div>
						</div>
						{/if}

						<div class="grid:fr-1 g-gap-40 y-center" data-aos="fade-up" data-aos-duration="500">
							<div class="text-tmp title-36 title-accent ">
								<h3>{$project.title}</h3>
								{$project.summary|page_break:0 nofilter}
							</div>
							<a class="btn accent" href="{$SITE_URL}{$project.url}">Подробнее</a>
						</div>
						{if $smarty.foreach.projects.iteration%2==0}
						<div class="grid:fr-1 g-gap-40" data-aos="fade-up" data-aos-duration="500">
							<div class="text-tmp title-36 title-accent max-w-650"><img src="{$project.image.original}" alt="{$project.title}"></div>
						</div>
						{/if}

					</div>
				{/foreach}

			</div>
		</div>

		{* project decor bg *}
		<div class="decor-bg">
			{include file="icon/svg.tpl" svgId="project_decor_bg" fill="none"}
		</div>
		{* /project decor bg *}

		<div class="decor-img-left building small" data-aos="fade-right" data-aos-duration="1000"><img src="{$ASSETS_URL}/images/common/decor/building-left.png" alt=""></div>
		<div class="decor-img-right building bot" data-aos="fade-left" data-aos-duration="1000"><img src="{$ASSETS_URL}/images/common/decor/building-right.png" alt=""></div>

	</section>
	{/if}
	{* /Проекты *}

	{* Котакты *}
	{include file="blocks/contacts.tpl"}
	{* /Котакты *}

</main>

{include file="footer.tpl"}