<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>
	{include file="modules/meta.tpl"}
    {include file="modules/link.tpl"}
	{include file="modules/recaptcha.tpl"}

</head>
<body>

{fetch_sections assign=headerMenus status="V" topMenu=1 level=1}

<header class="header {if (isset($section) && $section.parentId eq 3) || isset($article)}sticky{/if}">
	<div class="flex:col-max">
		<div class="header__inner">
			{* logo *}
			{logo link=true classLink="header__logo logo"}
			{* /logo *}

			<div class="header__item-first">
				<nav class="header__nav">
					{* menu *}
					{include file="modules/menu.tpl"}
					{* /menu *}
				</nav>

				<div class="header__item">
					<div class="header__contacts">
						<button class="header__contacts-btn">
							<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
								<path d="M757.231-160q-101.154 0-207.385-50.654-106.231-50.653-197.385-142.192-91.154-91.539-141.807-197.385Q160-656.077 160-757.231q0-18.33 12-30.549Q184-800 202-800h98.923q16.308 0 28.462 10.269t16.461 26.346L365.692-668q2.77 16.769-1 29.308-3.769 12.538-13.307 20.538l-87.77 81.846q24.616 44.693 54.424 83.039 29.807 38.346 63.576 72.654 34.847 34.846 75 64.807 40.154 29.962 88.154 56.577l85.539-87.077q9.769-10.538 21.961-13.884 12.192-3.347 26.962-1.347l84.154 17.231q16.308 4 26.461 16.423Q800-315.462 800-299.385V-202q0 18-12.22 30-12.219 12-30.549 12ZM244.846-573.846l76.769-70.616q3.846-3.077 5-8.461 1.154-5.385-.384-10l-17.77-84.769q-1.538-6.154-5.384-9.231t-10-3.077H211q-4.615 0-7.692 3.077t-3.077 7.692q1.154 41 12.846 85.616 11.692 44.615 31.769 89.769Zm338 333.384q40.539 20.077 86.423 29.693 45.885 9.615 79.962 10.307 4.615 0 7.692-3.076 3.077-3.077 3.077-7.693v-80.307q0-6.154-3.077-10-3.077-3.847-9.231-5.385l-74-15.154q-4.615-1.538-8.077-.384-3.461 1.153-7.307 5l-75.462 76.999Zm-338-333.384Zm338 333.384Z" />
							</svg>
						</button>

						<ul>
							{assign var=phones value=", "|explode:$config.phone}
							{foreach from=$phones item=phone name=phones}
								<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
							{/foreach}
							<li>{$config.operating_mode}</li>
						</ul>
					</div>

					<div class="header__lang">
						{* lang *}
						{include file="modules/lang.tpl"}
						{* /lang *}
					</div>

					<button class="burger-btn burger-btn_short header-btn_js">
						<span class="burger-btn__item"></span>
					</button>
				</div>
			</div>
		</div>
	</div>

	{* mobile *}
	<div class="header-mob header-mob_js">
		<div class="header-mob__inner">
			<div class="header-mob__head">
				{* logo *}
				{logo link=true classLink="logo"}
				{* /logo *}

				<div class="footer__list-phone">
					<ul>
						{assign var=phones value=", "|explode:$config.phone}
						{foreach from=$phones item=phone name=phones}
							<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
						{/foreach}
						<li>Консультации и расчёт</li>
					</ul>
				</div>
			</div>

			<div class="header-mob__common">
				<div class="header-mob__nav tab_js accard_js">
					{* menu *}
					{include file="modules/menu.tpl"}
					{* /menu *}
				</div>
			</div>

			<div class="header-mob__footer">

				<div class="footer__list-mail">
					<ul>
						<li>Электронная почта:</li>
						<li><a href="mailto:{$config.email}">{$config.email}</a></li>
					</ul>
				</div>
				<div class="social">
					{* socials icons *}
					{include file="modules/socials.tpl" path="/images/icons/social/"}
					{* /socials icons *}
				</div>
			</div>
		</div>
	</div>
	{* /mobile *}
</header>
