{include file="header.tpl" title=$article.title keywords=$article.keywords description=$article.description}

<main class="main">

	<section class="flex:col pad-tb-50 pos-rel">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<a class="btn-back" href="#" onclick="window.history.back();return false;">Назад</a>

				<div class="text-tmp title-48 title-tt-up">
					<h1>{$article.title}</h1>
					<p><time>{$article.publishedOn|date_format:$config.date_format_custom}</time></p>
					{if isset($article.image.original)}
						<img src="{$article.image.original}" alt="{$article.title}">
					{/if}
				</div>

				<div class="flex:row max-w-1000 x-center">
					<div class="news-social">
						<div class="social accent-theme">
							<ul>
								<li><a href="https://t.me/share/url?url={$SITE_URL}{$article.url}&text={$article.summary}" target="_blank"><img src="{$ASSETS_URL}/images/icons/social/telegram.svg" alt=""></a></li>
								<li><a href="https://www.facebook.com/sharer.php?u={$SITE_URL}{$article.url}" target="_blank"><img src="{$ASSETS_URL}/images/icons/social/facebook.svg" alt=""></a></li>
								<li><a href="https://www.instapaper.com/edit?url={$SITE_URL}{$article.url}&title={$article.title}" target="_blank"><img src="{$ASSETS_URL}/images/icons/social/instagram.svg" alt=""></a></li>
							</ul>
						</div>
					</div>

					<div class="text-tmp title-28 title-tt-up">
						{$article.content|page_break:null nofilter}
					</div>
				</div>
			</div>
		</div>
	</section>


	{fetch_articles limit=4 assign=news assignPagination=pagination section=5 image=true articleId=$article.articleId}{if !empty($news)}
	<section class="flex:col pad-tb-50 block-shadow">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="block-head">
					<div class="text-tmp title-40 title-tt-up title-accent-2"><h2>Рекомендуемы статьи</h2></div>
				</div>

				<div class="grid:fr-4 g-gap-20 max">
					{foreach from=$news item=new}
						{* news item *}
						{include file="items/news.tpl" type="" position="right" truncateTitle=64 truncateSummary=200}
						{* /news item *}
					{/foreach}
				</div>
			</div>
		</div>
	</section>
	{/if}

	{* Котакты *}
	{include file="blocks/contacts.tpl"}
	{* /Котакты *}

</main>


{include file="footer.tpl"}