<?php

use Mnv\Core\Config;

require_once('includes/overall.inc.php');
	
	$smarty->setTemplateDir( THEME_ROOT);
	$smarty->setCompileId('main'.Config::getValue('theme'));
	
	$articleId = (int) request()->get('articleId');
	$article   = request()->get('article');
	
	if (empty($article)) {
		/* preview from articles list */

		if($article = connect('articles')->where('articleId', $articleId)) {
			$article = prepareArticle($article);
		} else {
			die('Article not found');
		}
	} else {
		/* preview from "Preview" button */
		$article = prepareArticle($article);
	}
	
	if (!empty($article->sectionId)) {
		/* for "you-are-here" navigation */
		$sectionParents = getSectionParents($article->sectionId);
		$smarty->assign('sectionParents', $sectionParents);
		$smarty->assign('activeSection', $article->sectionId);
	}

	$smarty->assign('article', $article);
	$smarty->display('article.tpl');	
	
?>