<?php

use Mnv\Core\Config,
    Mnv\Core\Design,
    Mnv\Core\Maps,
    Mnv\Core\Locale\I18N,
    Mnv\Core\Utilities\Url;

const LS_VERSION    = '11.0.01';
const LS_SERIAL     = '+998 (90) 345-11-33';
const PRODUCT_NAME  = 'LS SHOP PANEL (https://www.life-style.uz/)';

/** Checking the PHP version on your server */
if (PHP_VERSION_ID < 70400) {
    echo 'LS PANEL required PHP version 7.4 or greater. You need to upgrade PHP version on your server.';
    die();
}

/** Autoloader */
require_once 'composer/vendor/autoload.php';

define('GLOBAL_ROOT', realpath(dirname(__FILE__) . '/../'));
define('REQUESTED_FILE', substr(strrchr($_SERVER['REQUEST_URI'], '/'), 1));
define('FS_READ_MODE', 'fopen');

const UPLOAD_ROOT   = GLOBAL_ROOT . '/uploads/';
const ERRORS_LOG    = GLOBAL_ROOT . "/temp/log/";

/** загрузить все языки */
$LANGUAGES = include GLOBAL_ROOT . '/includes/global-languages.inc.php';
/** определить язык */
define('SITE_LANG', isset($_GET['SITE_LANG'], $LANGUAGES[$_GET['SITE_LANG']]) ? $_GET['SITE_LANG'] : '');
if (!empty(SITE_LANG)) {
    define('SITE_LANG_PATH', '/' . SITE_LANG);
    define('SITE_LANG_PREFIX', SITE_LANG . '_');
    define('SITE_LANG_POSTFIX', '-' . SITE_LANG);
    define('SITE_ROOT', GLOBAL_ROOT . SITE_LANG_PATH);
} else {
    define('SITE_LANG_PATH', '');
    define('SITE_LANG_PREFIX', '');
    define('SITE_LANG_POSTFIX', '');
    define('SITE_ROOT', GLOBAL_ROOT);
}

/** определить https:// */
define('IS_HTTPS', Url::is_https());
define("GLOBAL_URL", (IS_HTTPS ? 'https://' : 'http://') . $_SERVER['HTTP_HOST']);
const GLOBAL_URI    = '';
const SITE_URL      = GLOBAL_URL . SITE_LANG_PATH;
const UPLOAD_URL    = GLOBAL_URL . SITE_LANG_PATH . '/uploads';
const SITE_URI      = '/' . SITE_LANG_PATH;

if (SITE_LANG !== '' && $LANGUAGES[SITE_LANG]['isDefault'] === 1) {
    redirect(GLOBAL_URL);
    die('Moving to '.GLOBAL_URL);
}
const ASSETS_URL    = GLOBAL_URL . '/themes/assets';

$gmNow = gmdate('Y-m-d H:i:s');
/** типы визитов */
$allVisitTypes[1]['name'] = 'Home';
$allVisitTypes[2]['name'] = 'Section';
$allVisitTypes[3]['name'] = 'Article';
$allVisitTypes[4]['name'] = 'Search';
$allVisitTypes[5]['name'] = 'AdClick';
$allVisitTypes[6]['name'] = 'Error';
$allVisitTypes[7]['name'] = 'RSS';
$allVisitTypes[8]['name'] = 'Sitemap';
$allVisitTypes[9]['name'] = 'Product';

/** Сценарий начала времени */
[$uSec, $sec] = explode(' ', microtime());
$scriptStartTime = ((float)$uSec + (float)$sec);

/** включить отчет об ошибках */
error_reporting(\E_ALL);
ini_set('display_errors', 'stdout');

/** подключение компонентов */
$databaseConfig = require GLOBAL_ROOT . '/includes/config.inc.php';
require_once GLOBAL_ROOT . '/includes/helpers.inc.php';
require_once GLOBAL_ROOT . '/includes/functions.inc.php';
/** Установить префикс таблиц DB */
define('TBL_PREFIX', $databaseConfig['prefix']);
/** Вся таблица DB */
require_once GLOBAL_ROOT . '/includes/db.table.inc.php';

/** инициализации */
/** Получение настроек */
$config     = Config::init()->config();
/** Получение настроек карты */
$maps       = Maps::init()->get();
/** инициализации Smarty  */
$smarty     = Design::init()->design();


/** установка кода языка (ru, uz, en) */
I18N::set(Config::getValue('website_language'));

/** определение пути до темы */
define('THEME_URL', (empty($THEME_URL) || IS_HTTPS) ? GLOBAL_URL . '/themes/' . Config::getValue('theme') : $THEME_URL);
define('THEME_ROOT', (empty($THEME_ROOT) || IS_HTTPS) ? GLOBAL_ROOT.'/themes/'. Config::getValue('theme') : $THEME_ROOT);

/** назначение основных переменных */
$smarty->assign('config',           $config);
$smarty->assign('maps',             $maps);
$smarty->assign('SITE_URL',   SITE_URL);
$smarty->assign('SITE_URI',   SITE_URI);
$smarty->assign('SITE_LANG',  SITE_LANG);
$smarty->assign('THEME_URL',  THEME_URL);
$smarty->assign('ASSETS_URL', ASSETS_URL);
$smarty->assign('GLOBAL_URL', GLOBAL_URL);
$smarty->assign('GLOBAL_URI', GLOBAL_URI);
$smarty->assign('UPLOAD_URL', UPLOAD_URL);
$smarty->assign('IS_HTTPS',   IS_HTTPS);
$smarty->assign('LANG', siteLanguage(Config::getValue('website_language')));
$smarty->assign('DEVELOPER',   Mnv\Models\Users\UserTypes::DEVELOPER);

$smarty->assignByRef('LANGUAGES', $LANGUAGES);
$smarty->assignByRef('TREE', $TREE);
$smarty->assignByRef('SECTIONS', $SECTIONS);
$smarty->assignByRef('CURRENCIES', $CURRENCIES);
$smarty->default_modifiers = array('escape');

/** загрузка системных настроек, сериализация */
if (file_exists(SITE_ROOT . '/includes/serializations.inc.php')) {
    include str_replace("//", "/", SITE_ROOT) . '/includes/serializations.inc.php';
}

/** Заголовок кодировка */
header('Content-Type: text/html; charset=' . Config::getValue('charset'));
/** Заголовок продукта*/
header('X-Powered-By: ' . PRODUCT_NAME . ' - ' . LS_SERIAL);
if ( Config::getValue('only_ssl') && !\Mnv\Core\Utilities\Url::is_https() ) {
    $_SERVER['REQUEST_URI'] = htmlspecialchars($_SERVER['REQUEST_URI'], ENT_QUOTES, Config::getValue('charset') );
    header("HTTP/1.0 301 Moved Permanently");
    header("Location: https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
    die("Redirect");
}
/** disable passing Session IDs via URL */
@ini_set('session.use_trans_sid', 0);
@ini_set('session.use_only_cookies', 1);

/** сжатия GZIP */
@ob_start('ob_gzhandler');

require_once 'overall.pub.inc.php';
