<?php

namespace Mnv\Modules\Payment;

use Mnv\Modules\Payment\Upay\Form\UpayGenerationForm;
use Mnv\Modules\Payment\Payme\Form\PayMeGenerationForm;
use Mnv\Modules\Payment\Click\Form\ClickGenerationForm;
use Mnv\Modules\Payment\Paybox\Form\PayboxGenerationForm;
use Mnv\Modules\Payment\Apelsin\Form\ApelsinGenerationForm;
use Mnv\Modules\Payment\Uzum\Form\UzumGenerationForm;

/**
 * Class PaymentFactory
 * @package Mnv\Modules\Payment
 */
class PaymentFactory
{

    public static function paymentMethod($payment): ?string
    {
        switch ($payment['payment_system']){
            case 'payme' :
                $payment_system = self::PayMe();
                return $payment_system->form($payment);
                break;
            case 'click' :
                $payment_system = self::Click();
                return $payment_system->form($payment);
                break;
            case 'apelsin' :
                $payment_system = self::Apelsin();
                return $payment_system->form($payment);
                break;
            case 'paybox' :
                $payment_system = self::PayBox();
                return $payment_system->form($payment);
                break;
            case 'upay' :
                $payment_system = self::UPay();
                return $payment_system->form($payment);
                break;
            case 'uzum' :
                $payment_system = self::Uzum();
                return $payment_system->form($payment);
                break;
            default:
                return  '';
                break;
        }
    }


    /**
     * @return PayMeGenerationForm
     */
    public static function PayMe(): PayMeGenerationForm
    {
        return new PayMeGenerationForm();
    }

    /**
     * @return ClickGenerationForm
     */
    public static function Click() : ClickGenerationForm
    {
        return new ClickGenerationForm();
    }

    /**
     * @return ApelsinGenerationForm
     */
    public static function Apelsin() : ApelsinGenerationForm
    {
        return new ApelsinGenerationForm();
    }

    /**
     * @return UpayGenerationForm
     */
    public static function UPay() : UpayGenerationForm
    {
        return new UpayGenerationForm();
    }

    /**
     * @return PayboxGenerationForm
     */
    public static function PayBox() : PayboxGenerationForm
    {
        return new PayboxGenerationForm();
    }

    /**
     * @return UzumGenerationForm
     */
    public static function Uzum() : UzumGenerationForm
    {
        return new UzumGenerationForm();
    }
}