<?php

namespace Mnv\Modules\Payment\Click;

/**
 * Class ClickPaymentException
 * @package Mnv\Modules\Payment\Click
 */
class ClickPaymentException extends \Exception
{
    /** @var */
    const ERROR_INTERNAL_SYSTEM = -32400;

    /** @var */
    const ERROR_INSUFFICIENT_PRIVILEGE = -32504;

    /** @var */
    const ERROR_INVALID_JSON_RPC_OBJECT = -32600;

    /** @var  */
    const ERROR_METHOD_NOT_FOUND = -32601;

    /** @var */
    const ERROR_INVALID_AMOUNT = -31001;

    /** @var */
    const ERROR_TRANSACTION_NOT_FOUND = -31003;

    /** @var */
    const ERROR_INVALID_ACCOUNT = -31050;

    /** @var */
    const ERROR_COULD_NOT_CANCEL = -31007;

    /** @var */
    const ERROR_COULD_NOT_PERFORM = -31008;

    /** @var error array-like */
    public $error;

    public $error_note;
    public $error_code;

    /**
     * ClickException contructor
     * @param string $error_note
     * @param integer $error_code
     */
    public function __construct($error_note, $error_code)
    {
        $this->error_note = $error_note;
        $this->error_code = $error_code;

        $this->error = ['error_code' => $this->error_code];

        if ($this->error_note) {
            $this->error['error_note'] = $this->error_note;
        }
    }

    /**
     * @name error method
     * @return error array-like
     */
    public function error()
    {
        return $this->error;
    }
}