<?php

namespace Mnv\Models;


/**
 * Class Variants
 * @package Mnv\Models
 */
class Variants
{
    /** @var string */
    protected string $table = 'product_variants';

    /** @var string  */
    protected string $primaryKey = 'id';

    /**
     * Функция возвращает варианты товара
     * @param int $productId
     * @return array|mixed|null
     */
    public function all(int $productId)
    {
        if (!empty($productId)) {
            return connect()->table($this->table)->where('productId', $productId)->orderBy('orderBy')->indexKey($this->primaryKey)->getAllIndexes('array');
        }

        return null;
    }

    public function get(?int $variantId)
    {
        if (!empty($variantId)) {
            return connect()->table($this->table)->where($this->primaryKey, $variantId)->get('array');
        }

        return null;
    }

    public function add(array $variant): int
    {
        if (empty($variant['id'])) unset($variant['id']);
        if (empty($variant['price'])) $variant['price'] = '0.00';
        if (empty($variant['oldPrice'])) $variant['oldPrice'] = '0.00';
        $variant['orderBy'] = 0;

        return connect()->table($this->table)->insert($variant);
    }

    /**
     * @param int $id
     * @param array $variant
     */
    public function update(int $id, array $variant)
    {
        connect()->table($this->table)->where($this->primaryKey, $id)->update($variant);
    }

    public function remove(int $id)
    {
        connect()->table($this->table)->where($this->primaryKey, $id)->delete();
    }




}