<?php


namespace Mnv\Models;


use Mnv\Core\Bot\Telegram;
use Mnv\Core\Test\Log;
use Mnv\Http\Request;

class TelegramNotification
{

    /** @var string */
    protected string $table = 'telegram_notifications';


    private $error = array();
    private $ssl = false;
    private $messengers = array();
    private $messengers_text = array();
    private $version = '1.0.0';

    public $setting;
    public $telegram_proxy_data;
    public $telegram_user_data;
    public $telegram_user_groupdata;
    public $telegram_langdata;
    public $key;

    public $logs = [
        0 => 'Выключены',
        1 => 'Только ошибки',
        2 => 'Полные (все запросы: успешные и ошибочные + тест уведомлений)',
    ];


    public $modal_headers = [
        'tab_template'          => 'Шаблоны уведомлений',
        'tab_users'             => 'Настройки пользователей',
        'tab_logs'              => 'Логи',
        'help_module'           => 'Инструкция по настройке модуля',
        'help_bot_telegram'     => 'Создать бота в Telegram',
        'help_trim_messages'    => 'Длинное сообщение',
        'help_timeout'          => 'Таймаут соединения',
        'help_proxy'            => 'Прокси',
        'help_id_telegram'      => 'Как получить ID пользователя в Telegram',
        'help_id_viber'         => 'Как получить ID пользователя в Viber',
        'help_log'              => 'Лог',
        'help_faq'              => 'Часто Задаваемые Вопросы',
        'help_support'          => 'Поддержка',
        'error_token'           => 'Неправильный Bot Token или недоступен мессенджер!',
        'error_warning'         => 'Внимание: Ваш  файл ошибок %s имеет размер %s!',

        'entry_get_token_telegram'      => 'Как получить Telegram Bot Ключ (токен)',
    ];


    public function __construct(Request $request)
    {
        $this->setting = $request->get('telegram');
        $this->telegram_proxy_data = $request->get('telegram_proxy_data');
        $this->telegram_user_data = $request->get('telegram_user_data');
        $this->telegram_user_groupdata = $request->get('telegram_user_groupdata');
        $this->telegram_langdata = $request->get('telegram_langdata');

        if (isset($request->server) && (($request->server('HTTPS') == 'on') || ($request->server('HTTPS') == '1'))) {
            $this->ssl = true;
        }

    }

    public function all()
    {
        $telegram = connect($this->table)->select('codename, value')->indexKey('codename')->valueKey('value')->getAllIndexes();
        if (!empty($telegram)) {
            if (!empty($telegram['telegram_proxy_data'])) {
                $telegram['telegram_proxy_data'] = json_decode($telegram['telegram_proxy_data'], true);
            }

            if (!empty($telegram['telegram_langdata'])) {
                $telegram['telegram_langdata'] = json_decode($telegram['telegram_langdata'], true);
            }

            $telegram['telegram_user_data'] = json_decode($telegram['telegram_user_data'], true);

            if (!empty($telegram['telegram_user_groupdata'])) {
                $telegram['telegram_user_groupdata'] = json_decode($telegram['telegram_user_groupdata'], true);
            }
        }

//        print_r($telegram);


        return $telegram;
    }

    public function update($data)
    {
        connect($this->table)->replace($data);
    }

    public function whereUpdate($key, $data)
    {
        connect($this->table)->where('codename', $key)->update($data);
    }


    public function readlogs($filename)
    {
        $file = GLOBAL_ROOT . '/temp/log/' . $filename;

        if (!is_file($file)) {
            return '';
        }

        if (file_exists($file)) {
            return htmlentities(file_get_contents($file, FILE_USE_INCLUDE_PATH, null));
        } else {
            return '';
        }
    }


    public function set_webhook($key, $timeout)
    {
        $telegram = new Telegram($key, $timeout);
        $telegram->setLog( new Log('telegram.log'), 2);

        if ($this->ssl) {
            $telegram->setWebhook(GLOBAL_URL . '/api-telegram');
        }

        $response = $telegram->getWebhookInfo();

        if (!$response) {
            if (($this->setting['proxy'] == '1') && (!empty($this->setting['proxydata']))) {
                $results = explode(';', $this->setting['proxydata']);
                foreach ($results as $proxy) {
                    if (!$response) {
                        $telegram->setProxy($proxy);
                        $response = $telegram->getBotInfo();

                        if ($response) {
                            $json['webhook'] = 'potential';
                            $json['message'] = 'Проверка прошла успешно!';
                            $json['type'] = 'success';

                            $this->editSettingValue('telegram_key', $this->setting['telegram_key']);
                            $this->editSettingValue('webhook', 'potential');
                        }
                    }
                };
            }
        } else {
            if ((isset($response['url'])) && (($response['url']) == (GLOBAL_URL . '/api-telegram'))) {
                $json['webhook'] = 'tg://resolve?domain=' . $telegram->getBotInfo()['username'];

                $this->editSettingValue('telegram_key', $this->setting['telegram_key']);
                $this->editSettingValue('webhook', $json['webhook']);
            } else {
                $json['webhook'] = 'potential';

                $this->editSettingValue('telegram_key', $this->setting['telegram_key']);
                $this->editSettingValue('webhook', 'potential');
            }

            $json['message'] = 'Проверка прошла успешно!';
            $json['type'] = 'success';
        }

        if (!isset($json['type']) || $json['type'] != 'success') {
            $json['message'] = 'Неправильный Bot Token или недоступен мессенджер!';
            $json['type'] = 'error';
        }

        if (!isset($json['webhook'])) {
            $json['webhook'] = 'no';
        }



        return $json;
    }

    public function editSettingValue($codename = '', $value = '')
    {
        $updateSetting['codename'] = $codename;
        $updateSetting['value'] = $value;

        $this->update($updateSetting);
    }

    public function users()
    {
        return connect('users')->select('userId, loginName')->in('userType', ['A', 'D'])->orderBy('userId ASC')->indexKey('userId')->getAllIndexes('array');
    }

    public function callMeVar()
    {
        $temp = array();
        $temp['{fullName}']     = 'Ф.И.О.';
        $temp['{phone}']        = 'Телефон';
        $temp['{date_added}']   = 'Дата и время добавления';

        return $temp;
    }

    public function feedbackVar()
    {
        $temp = array();
        $temp['{firstName}']    = 'Имя';
        $temp['{lastName}']     = 'Фамилия';
        $temp['{fullName}']     = 'Ф.И.О.';
        $temp['{phone}']        = 'Телефон';
        $temp['{email}']        = 'E-mail';
        $temp['{message}']      = 'Сообщение';
        $temp['{date_added}']   = 'Дата и время добавления';

        return $temp;
    }

    public function questionVar()
    {
        $temp = array();
        $temp['{fullName}']     = 'Ф.И.О.';
        $temp['{phone}']        = 'Телефон';
        $temp['{email}']        = 'E-mail';
        $temp['{type}']         = 'Способ связи';
        $temp['{message}']      = 'Сообщение';
        $temp['{date_added}']   = 'Дата и время добавления';

        return $temp;
    }

    public function serviceVar()
    {
        $temp = array();
        $temp['{fullName}']     = 'Ф.И.О.';
        $temp['{phone}']        = 'Телефон';
        $temp['{email}']        = 'E-mail';
        $temp['{message}']      = 'Сообщение';
        $temp['{date_added}']   = 'Дата и время добавления';

        return $temp;
    }

    public function quickOrderVar()
    {
        $temp = array();
        $temp['{fullName}']     = 'Ф.И.О.';
        $temp['{phone}']        = 'Телефон';
        $temp['{email}']        = 'E-mail';
        $temp['{message}']      = 'Сообщение';
        $temp['{product_id}']   = 'ID продукта';
        $temp['{quantity}']     = 'Кол-во';
        $temp['{product_name}'] = 'Название продукта';
        $temp['{date_added}']   = 'Дата и время добавления';

        return $temp;
    }

    public function orderVars()
    {
        $temp = array();
        $temp['{order_id}']         = 'Номер заказа';
        $temp['{store_name}']       = 'Название магазина';
        $temp['{user_fullName}']    = 'Ф.И.О.';
        $temp['{user_firstname}']   = 'Имя';
        $temp['{user_lastname}']    = 'Фамилия';
        $temp['{user_email}']       = 'E-mail';
        $temp['{user_phone}']       = 'Телефон';
        $temp['{payment_method}']   = 'Способ оплаты';
        $temp['{shipping_address}'] = 'Адрес доставки';
        $temp['{shipping_date}']    = 'Дата и время доставки';
        $temp['{shipping_method}']  = 'Способ доставки';
        $temp['{total}']            = 'Итого';
        $temp['{message}']          = 'Комментарий';
        $temp['{order_status}']     = 'Статус заказа';
        $temp['{date_added}']       = 'Дата и время добавления';
        $temp['{date_modified}']    = 'Дата и время изменения';
        $temp['{cart_start}']       = 'Начало корзины';
        $temp['{product_name}']     = '&nbsp;—&nbsp;Название товара';
        $temp['{product_options}']  = '&nbsp;—&nbsp;Опции товара';
        $temp['{product_url}']      = '&nbsp;—&nbsp;Ссылка на товар';
//        $temp['{product_model}']    = '&nbsp;—&nbsp;Модель товара';
        $temp['{product_sku}']      = '&nbsp;—&nbsp;Артикул товара';
        $temp['{product_price}']    = '&nbsp;—&nbsp;Цена товара';
        $temp['{product_quantity}'] = '&nbsp;—&nbsp;Кол-во товара';
        $temp['{product_total}']    = '&nbsp;—&nbsp;Итого товара';
        $temp['{cart_finish}']      = 'Конец корзины';


        return $temp;
    }
}