

	<!-- Page header -->
	{capture name="buttons"}
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/referer" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/referer"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					{include file="components/selectors.tpl" action="{$adminUrl}/referer" select=''}
				</div>

			    <div class="card border shadow-sm">
				    <div class="card-header d-flex flex-wrap">
					    <h6 class="mb-0">{$title}</h6>
					    <div class="d-inline-flex ms-auto">
						    <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
					    </div>
				    </div>
				    <div class="collapse show">
			            <table class="table table-xs table-striped table-actions table-hover">
			                <thead>
			                <tr>
			                    <th class="text-center">{stats:visitors}</th>
			                    <th class="text-center">{stats:referer}</th>
			                </tr>
			                </thead>
			                {if isset($referers) && !empty($referers)}
			                <tbody>
			                    {foreach item=referer from=$referers name=referers}
			                        <tr>
			                            <td class="text-nowrap">
			                                <a href="{$adminUrl}/visitors?domain={$referer.domain|escape:'url'|default:'unknown'}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}">{$referer.totalVisitors}</a>
			                            </td>
			                            <td class="text-left" width="100%">{$referer.website|truncate:40|default:'(неизвестный)'}</td>
			                        </tr>
			                    {/foreach}
			                </tbody>
			                {else}
			                    <tbody> <tr class="odd"><td class="text-center" colspan="4">- {general:none} -</td></tr></tbody>
			                {/if}

			            </table>
				    </div>
	                {include file="module/pagination.tpl" url="{$adminUrl}/referer" params="{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}"}
			    </div>
			</div>
		</div>
	</div>
	<!-- /content area -->
