<form method="post" enctype="multipart/form-data">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/payments"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/payments" class="breadcrumb-item">{$title}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <div class="content">

        <div class="row">
            <div class="col-md-8">

                <div class="card border shadow-sm">
	                <div class="card-header d-flex flex-wrap">
		                <h6 class="mb-0">{general:card:general}</h6>
		                <div class="d-inline-flex ms-auto">
			                <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
		                </div>
	                </div>
	                <div class="collapse show">
	                    <div class="card-body">
	                        <div class="row">
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.name)}text-danger{/if}">Название способа оплаты</label>
	                                    <input type="text" class="form-control" id="title" autocomplete="off" name="payment[name]" value="{$payment.name|default:""}" onblur="proposeFileName('name', 'fileName', 'payment', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');" >
	                                </div>
	                            </div>
	                            <div class="col-md-6">
		                            <div class="form-group mb-3">
		                            <label class="form-label is-visible {if isset($errors.fileNameExists)}text-danger{/if}">Выберите платежную систему</label>
		                            <select name="payment[fileName]" id="payment_module" class="form-control select">
			                            <option value="">Выберите платежную систему</option>
	                                    {foreach from=$payment_modules item=payment_module key=key}{$payment.fileName} - {$key}
				                            <option value="{$key|escape}" {if isset($payment.fileName) && $payment.fileName == $key}selected{/if} >{$payment_module.name|escape}</option>
	                                    {/foreach}
		                            </select>
		                            </div>
	{*                                <div class="form-group mb-3">*}
	{*                                    <label class="form-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>*}
	{*                                    <input  type="text" class="form-control" id="fileName" autocomplete="off" name="payment[fileName]" value="{if isset($payment.fileName)}{$payment.fileName}{/if}" />*}
	{*                                </div>*}
	                            </div>
	                        </div>
	                    </div>
	                </div>
                </div>

                <div class="card border shadow-sm">
	                <div class="card-header d-flex flex-wrap">
		                <h6 class="mb-0">{general:card:description}</h6>
		                <div class="d-inline-flex ms-auto">
			                <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
		                </div>
	                </div>
	                <div class="collapse show">
	                    <div class="card-body flex-column flex-md-row m-0 p-0">
	                        <div class="tab-content border-top-0 rounded-top-0 mb-0">
	                            <div class="tab-pane fade show active" id="summary">
	                                <textarea name="payment[summary]" class="description">{$payment.summary|default:""}</textarea>
	                            </div>
	                        </div>
	                    </div>
	                </div>
                </div>
            </div>


            <div class="col-md-4">
	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
	                    <div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="payment[status]" array=$statuses selected=$payment.status|default:'V' class="form-group mb-3"}
                            {* /field status *}
	                    </div>
                        {if isset($payment.addedOn) && isset($payment.modifiedOn)}
			            <div class="card-footer hstack gap-3 justify-content-between">
				            <div class="text-muted">
					            <ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{general:created}</li>
                                    <li>{general:modified}</li>
					            </ul>
				            </div>
				            <div class="hstack gap-1">
					            <ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{$payment.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$payment.addedBy.loginName|default:"{general:unknownUser}"})</li>
                                    <li>{$payment.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$payment.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
					            </ul>
				            </div>
			            </div>
                        {/if}
		            </div>
                </div>

                <div class="card border shadow-sm">
	                <div class="card-header d-flex flex-wrap">
		                <h6 class="mb-0">{general:card:providerPaymentSystem}</h6>
		                <div class="d-inline-flex ms-auto">
			                <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
		                </div>
	                </div>
	                <div class="collapse show">
	                    <div class="card-body border-top-0">
	                        {* Параметры модуля оплаты *}
	{*                        {if isset($payment.fileName)}*}
	                            {foreach from=$payment_modules item=payment_module key=key}
	                            {if isset($payment.fileName) && $key|upper eq $payment.fileName|upper}
			                        <figure id="module_settings" module="{$key}" {if $key != $payment.fileName|escape} style="display:none;"{/if}>
			                            <div class="form-group form-group-float">
				                            <div class="form-group form-group-float">{image_file_name_exists filePath="/payment/$key/logo.png" style="width: 105px"}</div>

				                            {foreach from=$payment_module.settings item=setting}
					                            {if isset($setting.options) &&$setting.options|count > 1}
					                                <div class="form-group mb-3">
						                                <label class="form-label is-visible">{$setting.name}</label>
						                                <select name="payment[settings][{$setting.variable}]" class="form-control select">
							                                {foreach from=$setting.options item=option}
								                                <option value="{$option.value}" {if !empty($payment.settings[$setting.variable]) && $option.value eq $payment.settings[$setting.variable|escape]}selected{/if}>{$option.name|escape}</option>
							                                {/foreach}
						                                </select>
					                                </div>
					                            {elseif isset($setting.options) && $setting.options|count eq 1}
						                            {$option = $setting.options|@first}
						                            <div class="form-group mb-3">
							                            <label class="form-label is-visible" for="{$setting.variable}">{$setting.name|escape}</label>
							                            <input type="text" class="form-control" name="payment[settings][{$setting.variable}]" value="{if !empty($payment.settings->{$setting->variable})}{$payment.settings->{$setting->variable}}{/if}" id="{$setting.variable}" />
						                            </div>
					                            {else}
						                            <div class="form-group mb-3">
							                            <label class="form-label is-visible" for="{$setting.variable}">{$setting.name|escape}</label>
							                            <input type="text" class="form-control" name="payment[settings][{$setting.variable}]" value="{if !empty($payment.settings)}{$payment.settings[$setting.variable]}{/if}" id="{$setting.variable}" />
						                            </div>
					                            {/if}
				                            {/foreach}
				                            {* END Параметры модуля оплаты *}
			                            </div>
			                        </figure>
		                        {/if}
		                        {/foreach}
	{*	                    {else}*}
	{*                            {foreach from=$payment_modules item=payment_module key=key}*}
	{*	                            <figure style="display:none;"id="module_settings" module='{$key}'>*}
	{*		                            <div class="form-group form-group-float">*}
	{*			                            <div class="form-group form-group-float">{image_file_name_exists filePath="/payment/$key/logo.png" style="width: 100px"}</div>*}

	{*			                            {foreach from=$payment_module->settings item=setting}*}
	{*				                            {if isset($setting->options) &&$setting->options|count > 1}*}
	{*					                            <div class="form-group form-group-float">*}
	{*						                            <label class="form-group-float-label is-visible">{$setting->name}</label>*}
	{*						                            <select name="payment[settings][{$setting->variable}]" class="form-control select">*}
	{*							                            {foreach from=$setting->options item=option}*}
	{*								                            <option value="{$option->value}">{$option->name|escape}</option>*}
	{*							                            {/foreach}*}
	{*						                            </select>*}
	{*					                            </div>*}
	{*				                            {elseif isset($setting->options) && $setting->options|count eq 1}*}
	{*					                            {$option = $setting->options|@first}*}
	{*					                            <div class="form-group form-group-float">*}
	{*						                            <label class="form-group-float-label is-visible" for="{$setting->variable}">{$setting->name|escape}</label>*}
	{*						                            <input type="text" class="form-control" name="payment[settings][{$setting->variable}]" value="" id="{$setting->variable}" />*}
	{*					                            </div>*}
	{*				                            {else}*}
	{*					                            <div class="form-group form-group-float">*}
	{*						                            <label class="form-group-float-label is-visible" for="{$setting->variable}">{$setting->name|escape}</label>*}
	{*						                            <input type="text" class="form-control" name="payment[settings][{$setting->variable}]" value="" id="{$setting->variable}" />*}
	{*					                            </div>*}
	{*				                            {/if}*}
	{*			                            {/foreach}*}

	{*		                            </div>*}
	{*	                            </figure>*}

	{*                            {/foreach}*}
	{*                        {/if}*}
	                        {* END Параметры модуля оплаты *}

	                    </div>
	                </div>
                </div>

            </div>

	        <div class="col-md-12 text-center">
                {if isset($payment.paymentId)}<input type="hidden" class="form-control" id="id" name="id" value="{$payment.paymentId}">{/if}
                {$smarty.capture.buttons nofilter}
	        </div>
        </div>
    </div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

<script>

    $(document).ready(function () {
        {if isset($errors.access_denied)} new Noty({ text: '{payments:errors:access_denied}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.name)} new Noty({ text: '{payments:errors:name}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{payments:errors:fileNameExists}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{payments:errors:not_saved}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.payment_not_found)} new Noty({ text: '{payments:errors:payment_not_found}', type: 'error', timeout: 3000 }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{payments:messages:payment_save}', type: 'success', timeout: 1500 }).show(); {/if}
    });

    $('select[name="payment[fileName]"]').change(function(){
        $('figure#module_settings').hide().find("input, select").attr("disabled", true);
        $('figure#module_settings[module=' + $(this).val() + ']').show().find("input, select").attr("disabled", false);
    });

</script>
