<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/blocks?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/blocks" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">

		<div class="row">
			<div class="col-md-8">

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.sectionId)}text-danger{/if}">{general:section}</label>
                                        {html_options options=$sections name="block[sectionId]" id="sectionId" selected=$block.sectionId|default:'' class="form-control select-search select"}
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.title)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" id="title" autocomplete="off" name="block[title]" value="{$block.title|default:''}">
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label">{general:alias}</label>
										<input type="text" class="form-control" id="alias" autocomplete="off" name="block[alias]" value="{$block.alias|default:''}">
									</div>
								</div>
                                {*                            <div class="col-md-12">*}
                                {*                                <div class="form-group form-group-float">*}
                                {*                                    <label class="form-group-float-label is-visible">{general:filename}</label>*}
                                {*                                    <input  type="text" class="form-control" id="fileName" autocomplete="off" name="block[fileName]" value="{if isset($block.fileName)}{$block.fileName}{/if}" />*}
                                {*                                </div>*}
                                {*            			    </div>*}
							</div>
						</div>
					</div>
				</div>

                {* фото галерея *}
				<div class="collapse {if isset($block.enableGallery) and $block.enableGallery eq 1}show{/if}" id="gallery-card">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">{general:card:imageLibrary}</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body">
								<div class="row gallery gallery-product gallery-sortable mt-2 sortable" id="fileList">
	                                {if isset($block.gallery)}
	                                    {foreach item=file from=$block.gallery}
											<figure class="gallery-item mb-0" id="gallery-item-{$file.imageId}" data-id="{$file.imageId}">
												<div class="move_zone image">
													<img src="{$file.medium}" alt="{$file.title|default:''}"/>
													<ul class="gallery-item-controls">
														<li><span>{$file.orderBy}</span></li>
														<li>
		                                                    <span class="edit_image" id="edit_image_{$file.imageId}"
		                                                          data-title="{$file.title}"
		                                                          data-alias="{$file.alias}"
		                                                          data-description="{$file.description}"
		                                                          data-link="{$file.link}"
		                                                          data-position="{$file.position}"
		                                                          onclick="editPictureInfo({$file.imageId}, 'Добавить описание к картинке', 'block');"><i class="ph-note-pencil"></i></span>
														</li>
														<li>
															<span onclick="deletePicture({$file.imageId}, 'block');"><i class="ph-trash"></i></span>
														</li>
													</ul>
												</div>
												<div class="meta" id="meta_image_{$file.imageId}">
													<span id="im_title" class="fs-sm fw-normal fw-semibold">{$file.title}</span>
													<span id="im_alias" class="fs-sm fw-normal">{$file.alias}</span>
													<span id="im_description" class="fs-sm fw-normal">{$file.description nofilter}</span>
													<span id="im_link" class="fs-sm fw-normal">{$file.link}</span>
													<span id="im_position" class="badge bg-primary text-white fs-sm fw-light">{$file.position}</span>
												</div>
											</figure>
	                                    {/foreach}
	                                {/if}
								</div>
							</div>

							<div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
								<button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="gallery" data-path="/" data-action="read_more"><i class="ph-image me-2"></i> {general:uploadFiles} </button>
	                            {*				            <button type="button" class="btn btn-sm btn-primary btn-sorting collapse" data-action="sortPictures" data-module="article"><i class="ph-check me-2"></i> {general:apply}</button>*}
							</div>
						</div>

					</div>
				</div>
                {* /фото галерея *}

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="content">
									<textarea id="description" name="block[content]" class="description">{if isset($block.content)}{$block.content}{/if}</textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-md-4">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="block[status]" array=$statuses selected=$block.status|default:'V'  class="form-group mb-3"}
                            {* /field status *}

                            {* field imageSize *}
{*                            {include file="components/fields/select.tpl" id="imageSizes" title="Размер изображения" field="block[image_size]" array=$imageSizes selected=$block.image_size|default:'F'  class="form-group mb-3"}*}
                            {* /field imageSize *}

                            {* field positions *}
                            {include file="components/fields/select.tpl" id="positions" title="Расположение изображения" field="block[position]" array=$positions selected=$block.position|default:'L'  class="form-group mb-3"}
                            {* /field imageSize *}

                            {* field background *}
{*                            {include file="components/fields/select.tpl" id="background" title="Фон" field="block[background]" array=$backgrounds selected=$block.background|default:'L'  class="form-group mb-3"}*}
                            {* /field background *}

							{* field positions *}
{*                            {include file="components/fields/select.tpl" id="text_positions" title="Расположение текста" field="block[text_position]" array=$text_positions selected=$block.text_position|default:''  class="form-group mb-3"}*}
                            {* /field imageSize *}

							<div class="form-check mb-3">
								<input type="checkbox" class="form-check-input" id="enableGallery" name="block[enableGallery]" value="1" {if isset($block.enableGallery) and $block.enableGallery eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card">
								<label class="form-check-label" for="enableGallery">Фотогалерея к этой публикации</label>
							</div>

						</div>

                        {if isset($block.addedOn) && isset($block.modifiedOn)}
							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
	                                    <li>{general:created}</li>
	                                    <li>{general:modified}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
	                                    <li>{$block.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$block.addedBy.loginName|default:"{general:unknownUser}"})</li>
	                                    <li>{$block.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$block.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
									</ul>
								</div>
							</div>
                        {/if}
					</div>
				</div>

                {* image preview *}
                {include file="components/image-preview.tpl"
                image="{if isset($block.image)}{$block.image.original}{/if}"
                id="{if isset($block.image)}{$block.image.imageId}{/if}"
                module='block'}
                {* /image preview *}

			</div>

			<div class="col-md-12 main main_buttons text-center">
                {if isset($block.blockId)}<input type="hidden" class="form-control" id="id" name="id" value="{$block.blockId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>


    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Блок сохранен', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.sectionId)} new Noty({ text: '{articles:errors:2}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Блок не сохранен', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: 'Нет ни одного раздела', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.position)} new Noty({ text: 'Необходимо выбрать номер позиции', type: 'error', timeout: 2500 }).show(); ;{/if}

    });

    function notFound() {
        new Noty({ text: '{articles:errors:6}', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }

    function successSortImageMessage() {
        new Noty({ text: 'Порядковый номер изменен', type: 'success', timeout: 1500 }).show();
    }


</script>
