<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Models\Shop\Coupons;
use Mnv\Models\Shop\Currencies;

/**
 * Class CouponsAdmin
 * @package Mnv\Admin\Controllers
 */
class CouponsAdmin extends AdminMnv
{

	public function fetch()
    {

        $coupon = new Coupons($this->request);

        $this->smarty->assign('activeItem','coupons');
        $this->smarty->assign('title', 'Купоны');
        $this->smarty->assign('defaultCurrency', Currencies::getDefaultCurrency()['codeName']);

        if ($this->action == 'apply') {
            if (empty($coupon->data['code'])) $this->errors['code'] = true;
            if (empty($coupon->data['value'])) $this->errors['value'] = true;
            if (empty($coupon->data['min_order_price'])) unset($coupon->data['min_order_price']);
            if (empty($coupon->data['expire'])) unset($coupon->data['expire']);


            $result = array('status' => 400, 'message' => $this->errors);
            if (empty($this->errors)) {
                if ($coupon->prepare($coupon->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                    $result = array('status' => 200, 'message' => $this->messages);
                } else {
                    $this->errors['not_saved'] = true;
                    $result = array('status' => 400, 'message' => $this->errors);
                }
            }

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        } else if ($this->action == 'remove') {

            $result = $coupon->remove()
                ? array('status' => 200, 'message' => 'Купон удален', 'type' => 'success')
                : array('status' => 403, 'message' => 'Ошибка при удаление купона', 'type' => 'error');
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        else if ($this->action == 'status') {

            $result = $coupon->status()
                ? array('data' => true, 'status' => $coupon->status, 'type' => 'success')
                : array('data' => false, 'status' => $coupon->status, 'type' => 'error');
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }


        $coupons = collect($coupon->all($this->limit, $this->page))->map(function ($item){
            if (!is_null($item['expire'])) {
                $item['expire'] = langDate(adjustTime($item['expire'], false, 'd.m.Y'));
            }

            return $item;
        })->all();


        $coupon->total();
        $pages = getPageNums($coupon->total, 1, 50, 0, 4, 4, 0);

        $this->smarty->assign('totalCoupons', $coupon->total);
        $this->smarty->assign('coupons',  $coupons);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

//        if ($this->permissions('coupons')) {
            return $this->smarty->fetch('views/coupons/coupons.tpl');
//        }
//
//        $this->smarty->assign('title', 'Access Denied');
//        return $this->smarty->fetch('accessIsDenied.tpl');


    }

}