<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Test\Logger;

use Mnv\Models\BannerGroups;
use Mnv\Models\Banners;

/**
 * Class BannersAdmin
 * @package Mnv\Admin\Controllers
 */
class BannersAdmin extends AdminMnv
{

	public function fetch()
    {

        $bannerImage = new Banners($this->request);

        $this->smarty->assign('activeItem','banners');
        $this->smarty->assign('title','Баннеры');


        if ($this->action == 'remove') {

            if ($bannerImage->remove()) {
                Logger::init()->info("Слайд « ID-" . $bannerImage->id . "» удален." . lang('articles:messages:2'), $this->manager['userId'])->save();
                $result = array('status' => 200, 'message' => 'Баннер удален', 'type' => 'success');
            } else {
                $result = array('status' => 403, 'message' => 'Ошибка при удаление баннера', 'type' => 'error');
            }
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        else if ($this->action == 'status') {

            $result = $bannerImage->status()
                ? array('data' => true, 'status' => $bannerImage->status, 'type' => 'success')
                : array('data' => false, 'status' => $bannerImage->status, 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        else if ($this->action == 'reorder') {
            $i = 0;
            $bannerImage->data = [];
            foreach ($bannerImage->bannerIds as $bannerId) {
                $i++;
                $bannerImage->id = $bannerId;
                $bannerImage->data['orderBy'] = $i;
                $bannerImage->update($bannerImage->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        }

        $bannerImages = collect($bannerImage->all($this->limit, $this->page))->map(function ($item) use ($bannerImage) {
            $item['statusName'] = lang('general:statuses:' . $item['status']);
            $item['groupName']  = BannerGroups::getGroupName($item['groupId']);
            $image              = $bannerImage->getMainImage($item['bannerId']);
            $item['image']      = !empty($image['original']) ? $image['original'] : '/admin/assets/img/no_images.jpg';

            return $item;
        })->all();


        $bannerImage->total();
        $pages = getPageNums($bannerImage->total, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('totalBanners', $bannerImage->total);
        $this->smarty->assign('banners',  $bannerImages);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('banners')) {
            return $this->smarty->fetch('views/banners/banners.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}