<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Filesystem\Filesystem;
use Mnv\Models\AdsBanner;

/**
 * Class AdsBannerAdmin
 * @package Mnv\Admin\Controllers
 */
class AdsBannerAdmin extends AdminMnv
{

    public function fetch()
    {
        $filesystem = new Filesystem();
        $banner = new AdsBanner($this->request);

        $lang = $this->request->get('SITE_LANG','');

        if (empty($lang)) $lang;

        $this->smarty->assign('activeItem','banners');
        $this->smarty->assign('title', lang('banners:sectionName'));

        if  ($this->action == 'add' || $this->action == 'edit') {

            $banner->edit()->gettingInfoAboutUsers();

        } else if ($this->action == 'save') {

            $banner->data['lang'] = $lang;
            if (empty($banner->data['isActive'])) $banner->data['isActive'] = 0;

            if (is_file($_FILES['file']['tmp_name'])) {
                $uploadedFile = getimagesize($_FILES['file']['tmp_name']);
                if ($uploadedFile[2] != 1 and $uploadedFile[2] != 2 and $uploadedFile[2] != 3 and $uploadedFile[2] != 4 and $uploadedFile[2] != 13) $this->errors['fileType'] = true;
                $fileSrc = $_FILES['file'];
            }

            if (empty($banner->data['bannerName'])) $this->errors['bannerName'] = true;

            if (empty($this->errors)) {

                if (!empty($fileSrc)) {
                    $banner->data['bannerWidth'] = $uploadedFile[0];
                    $banner->data['bannerHeight'] = $uploadedFile[1];
                    $banner->data['bannerType'] = $uploadedFile[2];

                    if (!is_dir(SITE_ROOT . '/uploads/bs') && !mkdir($concurrentDirectory = SITE_ROOT . '/uploads/bs', 0777) && !is_dir($concurrentDirectory)) {
                        throw new \RuntimeException(sprintf('Directory "%s" was not created', $concurrentDirectory));
                    }
                    /* Deleting old banner file */
                    if ($banner->data['fileUrl']) {
                        $filesystem->delete(SITE_ROOT . '/' . $banner->data['fileUrl']);
//                        @unlinkFile(SITE_ROOT . '/' . $banner->data['fileUrl']);
                    }

                    $fileExtension = explode(".", $_FILES['file']['name']);
                    $fileExtension = $fileExtension[sizeof($fileExtension) - 1];
                    $banner->data['fileUrl'] = 'uploads/bs/bs-' . substr(md5($_FILES['file']['name'] . time()), 3, 6) . '.' . $fileExtension;
                    move_uploaded_file($_FILES['file']['tmp_name'], SITE_ROOT . '/' . $banner->data['fileUrl']);
                    chmod(SITE_ROOT . '/' . $banner->data['fileUrl'], 0755);
                }

                $this->smarty->assignByRef('banner', $banner->data);
                $banner->data['generatedCode'] = $this->smarty->fetch('views/ads/generate-banner-code.tpl');

                if ($banner->prepare($banner->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $banner->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/ads");
            }

        } else if ($this->action == 'generateCode') {
            $banner->data['frame'] = $this->smarty->fetch('views/ads/banners-output.tpl');
        }

        $this->smarty->assign('banner', $banner->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if ($this->permissions('ads')) {
            return $this->smarty->fetch('views/ads/banner.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}


